-- now Works with:
--		multi-Clump DFF files (Import & Export)
--		all GTA 3 DFF (Import & Export), just 1 incorrect so far!!
--		Bones & Skins
--		almost all GTA VC DFF 
--		Reflection supported

if DFFinInfo == undefined then fileIn (scriptspath+"\\GTA_Tools\\saDFFin_Fn.mse") quiet:true 
if DFFoutInfo == undefined then fileIn (scriptspath+"\\GTA_Tools\\saDFFout_Fn.mse") quiet:true

Global Dummysize = 0.1		--control the dummy size, change it before pressing the Import Button 
Global SPscale = 1.0
Global SAColBase = undefined
--fns for developer to use:
--=========================
-- WhichRWver [filestream]			return: the RW file version

-- checkClump [filestream]			return: numbers of clumps in the file

-- CheckZmodLock [filestream]		return: TRUE if file is locked

-- DFFin [filestream] [Scale] [texture extension] [dummysize] [AutoSkin] \
--			[show Detail] [Name of SelectionSets]
--		the main import function, all object will be created inside this call
--		[scale]: global import scale of the dff file
--		[texture extension]: a text to tell the type of texture should MAX use
--								eg: ".tga"
--		[dummysize]: control the size of non-geometry object MAX will create 
--		[AutoSkin]: true/false if bones/skin data found. It will auto skin the data or not
--		[show Detail]: true/false option to display details in listener
--		[Name of SelectionSets]: everything in this import will be grouped with this given Name
--								 or undefined to skip grouping
--		return: the root object(geo/dummy) of the dff 

--DFFinInfo()						show the version of input functions 


-- RemapGeo [object]				return: undefined if the object is not supported
--											remapped object(Emesh) with same number
--											of UVs, verts, VertColors 

--DFFout [filestream] [objects] [ModulateMaretialColor] [UV switch] \
--			[VertColor switch] [Normal switch] [scale] [Version]
--		the main export function, all objects in [objects] will export to dff
--		[objects]: array contains all objects in scene will export to dff
--		[ModulateMaretialColor]: True/False whether use ModulateMaretialColor or not
--		[UV switch]: True/False whether Export UV coords or not
--		[VertColor switch]: True/False whether Export VertColor or not
--		[Normal switch]: True/False whether Export Normals or not
--		[scale]: global export scale of the dff file
--		[Version]: integer for use to identify the RW version

--DFFoutInfo()			 			show the version of output functions 


----------------------------------------------------------------------------------------------------

rollout DFFinPara "Import DFF" (
	Group "Multi. Clump" (
        spinner whichone "" type:#integer range:[1,1,1] align:#left fieldwidth:35 offset:[-3,3] across:2 enabled:false
        button useclump "Import" width:70 offset:[-3,0] enabled:false
	)
	group "" (
		label lbl1 "Image Type:" align:#left offset:[0,-7]
		radiobuttons textype "" labels:#("tga     ","bmp     ")
		spinner ISc "Import Scale: " fieldwidth:42 range:[0,100,SPscale] align:#left
		button imp "Import DFF" width:120 align:#left
	)
	group "" (
		checkbutton autoskin "A" width:17 tooltip:"Auto Skin after import dff character" highlightcolor:yellow align:#left across:2 offset:[0,-3]
		button skinchr "Skin the Character" width:103 tooltip:"Selected model must be Skin/bones ready" align:#right offset:[-2,-3]
		progressBar skinstate color:red height:8 offset:[0,-3]
		button RenameSel "Re-Name" width:61 tooltip:"Add BoneIndex to the name of objects for easy skinnig" align:#left across:2

		button RtnameSel "Restore" width:61 tooltip:"Restore Original names to selected objects" align:#right
	)
	
	on RenameSel pressed do (
		for obj in $selection do (
			onm = getUserProp obj "BoneIndex"
			if onm != undefined then (
				if onm <10 then obj.name = "0" + onm as string + "_" + (RestoreSpace obj.name)
				else obj.name = onm as string + "_" + (RestoreSpace obj.name)
			)
		)--end for	
	)

	on RtnameSel pressed do (
		for obj in $selection do (
			onm = getUserProp obj "FrameName"
			if onm != undefined then obj.name = RestoreSpace onm
		)--end for
	)--end on RenameSel

	on skinchr pressed do (
		if (SkinData != undefined)AND($selection.count == 1) then (
			global skn = $.modifiers[1]
			if (skn != undefined)AND(classof $ == Editable_mesh) then (
				if $.numVerts != SkinData[1].count then \
					messagebox "Skin Data Not correct!" title:"Skin Error"
				else (
					skn
					if (skinOps.GetNumberBones skn) != SkinData[3] then (
						messagebox "Bones count in skin Modifier Not correct!" title:"Skin Error"
					)	
 					else (
						skn
						for i = 1 to $.numVerts do (
							skinOps.SetVertexWeights skn i SkinData[1][i] SkinData[2][i]
							if (mod i 50) == 0 then skinstate.value = 100 * i/$.numVerts
						)
						skinstate.value = 0
						gc()
					)
				)
			) else messagebox "Skin modifier not found" title:"Skin Error"
		) else messagebox "Make sure you have selected the right character\nwith Skin modifier applied" title:""
	)--end on skinchr

	on Isc changed Val do (
		SPscale = Val
		try ( DFFexPara.ExSc.value = 1/Val ) catch()
	)

	on useclump pressed do (
		f = fopen fname "rb"
		if f != undefined then  (
			if whichone.value != 1 then fseek f no_clump[(whichone.value)] #seek_set
			texEx = case textype.state of (
				1: ".tga"
				2: ".bmp"
			)
			DFFin f ISc.value texEx dummysize autoskin.checked true undefined
			fclose f
			gc()
		) else (
			format "ERROR\n"
		)
	)--end on useclump
    
	on imp pressed do (
		fname = getopenfilename caption:"Read DFF File" types:"dff File (*.dff)|*.dff|"
		if fname != undefined then (
			f = fopen fname "rb"
			if f == undefined then ( Messagebox "Can't open the file!" title:"I/O Error" )
			else (
				no_clump = checkClump f
				if no_clump.count == 0 then messagebox "Not a Void DFF file!" title:"File Format Error"
				else (
					if no_clump.count == 1 then (
						texEx = case textype.state of (
							1: ".tga"
							2: ".bmp"
						)--end case
						DFFin f ISc.value texEx dummysize autoskin.checked true (getFilenameFile fname)
					) else (
						fclose f
						whichone.range = [1,no_clump.count,1]
						whichone.enabled = true
						useclump.enabled = true
						txt = "This DFF has " + no_clump.count as string + " Clumps.\nPlease choose one to Import!"
						Messagebox  txt title:""
					)
				)--end if/else no_clump
			)--end if/else f
		)
		fclose f
		gc()
	)--end on imp
    
)--end rollout DFFinPara


rollout DFFexPara "Export DFF" (

--	checkbutton VCor3 "GTA 3" width:120 tooltip:"Use GTA3/VC version format" highlightcolor:green align:#center

	checkbutton eGTA3 "GTA3" width:40 highlightcolor:green offset:[2,0] across:3
	checkbutton eVC   "VC"   width:40 highlightcolor:green
	checkbutton eSA   "SA"   width:40 highlightcolor:green checked:true

	spinner ExSc "Export Scale: " fieldwidth:42 range:[0,100,1/SPscale] align:#left
		checkbutton MMC "MMC" width:30 align:#left highlightcolor:yellow tooltip:"use Modulate Material Color" checked:false across:4
		checkbutton TUV "UV" width:30 align:#center highlightcolor:yellow tooltip:"export Texture UV" checked:true
		checkbutton NOR "Nor" width:30 align:#center highlightcolor:yellow tooltip:"export Normal" checked:true
		checkbutton CPV "VCol" width:30 align:#right highlightcolor:yellow tooltip:"export Prelit Vertex Color"
	group "" (
		checkbutton AppendFile "A" width:17 highlightcolor:orange align:#left tooltip:"Append export to DFF" offset:[0,-5] across:2
		button exp "Export DFF" width:103 tooltip:"Only selected objects will export" align:#right offset:[-2,-5]
		button BSexp "Bones/Skin Export" width:120 tooltip:"Select the skinned Character only" offset:[-2,-3]
	)
	group "SA collision Base" (
		button colbase "COL3 Model" width:120
	)  
	
	on colbase pressed do (
		Cname = getopenfilename caption:"Collision Base File" types:"DFF File (*.dff)|*.dff|COL File (*.col)|*.col|"
		if Cname != undefined then colbase.text = filenameFromPath Cname
		else colbase.text = "COL3 Model"	
		SAColBase = Cname
	)
	
	on eGTA3 changed state do (
		if state == true then (
			eVC.checked = false
			eSA.checked = false
		) else eGTA3.checked = true
	)
	on eVC changed state do (
		if state == true then (
			eGTA3.checked = false
			eSA.checked = false
		) else eVC.checked = true
	)
	on eSA changed state do (
		if state == true then (
			eGTA3.checked = false
			eVC.checked = false
		) else eSA.checked = true
	)
	
	on BSexp pressed do (
		if $selection.count != 1 then messagebox "Select the skinned Character only!" title:"Selection Error"
		else (
			if (classof $.modifiers[1] != skin) then \
				messagebox "This object is not skinned correctly!\nSkin modifier must be on the topmost of the stack!!" title:"Skin Error"
			else (

				if eVC.checked == true then		ver = 0X0C02FFFF			--VC Version
				if eGTA3.checked == true then	ver = 0x0800FFFF			--Standard GTA3 Version
				if eSA.checked == true then		ver = 0x1803FFFF
				
				max modify mode
				bkup = $.name
				$.name = "CharExpTemp"
				global skn = $.modifiers[1]
				skn
				boneCount = skinOps.getNumberBones skn
				boneReady = true
				global bonechain = #()
				for i = 1 to boneCount do (
					tmp = skinOps.getBoneName skn i 0
					tb = "append bonechain $'" + tmp + "'"
					bonechain
					execute tb
					tt = "getUserProp $'" + tmp + "' \"BoneID\""
					if (execute tt) == undefined then (
						boneReady = false
						exit
					)
					tt = "getUserProp $'" + tmp + "' \"BoneType\""
					if (execute tt) == undefined then (
						boneReady = false
						exit
					)					
				)--end for i
				$.name = bkup
				if boneReady == false then messagebox "You didn't set   BoneIDs/BoneTypes   properly!\nEach bone must have  'BoneID' & 'BoneType'  in it's User Properities." title:"BoneID/BoneType Error"
				else (
					for i = 1 to $.numverts do (
						if skinOps.GetVertexWeightCount skn i == 0 then (boneReady = false; exit)
					)
				)
				if boneReady == false then messagebox "You didn't set   Skin/Vertices   properly!\nEach Vertex must be influence by at least 1 Bone." title:"Skin Error"
				else (
					clearlistener()
					fname = getsavefilename caption:"Export DFF File" types:"dff File (*.dff)|*.dff|"
					if fname != undefined then (
						
						expscale = $.scale * ExSc.value
						
						global SkinData = CreateSkinData $

						f = fopen fname "wb"
						wCharDFFout f $ bonechain MMC.checked TUV.checked CPV.checked NOR.checked expscale ver
						fclose f
						format "\nfile:% exported!\n" fname
					)
				)--if/else boneReady
				
			)--end check Skin modifier
		)--end check $	
	)--end on BSexp
	
	on VCor3 changed state do (
		if state == true then VCor3.text = "Vice City"
		else VCor3.text = "GTA 3"
	)
	
	on ExSc changed Val do (
 		SPscale = 1/Val
		try ( DFFinPara.ISc.value = 1/Val ) catch()
	)

	on exp pressed do (
		if $selection.count != 0 then (
		
		if (eSA.checked==true)AND(SAColBase==undefined) then messagebox "You need to supply a Collosion model for SA Export!"
		else (
		
		RootObj = checkRoot $selection
		if  RootObj != undefined then (
			----------------------
			--Scale the Root obj--
			----------------------
			bkupRootTran = RootObj.transform
			expscale = RootObj.scale * ExSc.value
			RootObj.transform = matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]
		
				if eVC.checked == true then		ver = 0X0C02FFFF			--VC Version
				if eGTA3.checked == true then	ver = 0x0800FFFF			--Standard GTA3 Version
				if eSA.checked == true then		ver = 0x1803FFFF			--SA Version
				
			fname = undefined
	
			if AppendFile.checked == true then (
				Sname = getopenfilename caption:"Append DFF File" types:"dff File (*.dff)|*.dff|"
				if Sname != undefined then (
					fo = fopen Sname "rb"
					if fo != undefined then  (
						no_clump = checkClump fo
						fseek fo (no_clump[no_clump.count]+4) #seek_set
						skip = readLong fo #unsigned
						readLong fo
						skip += (ftell fo)
						fname = (getFilenamePath Sname) + "temp.dff"
						if fname != undefined then (
							f = fopen fname "wb"
							fseek fo 0 #seek_set
							for i = 1 to skip do (
								writeByte f (readByte fo #unsigned)
							)--end for i
							fclose fo	
						)--end if fname	
					)--end if fo
				)--end if Sname
			) else (
				fname = getsavefilename caption:"Export DFF File" types:"dff File (*.dff)|*.dff|"
				if fname != undefined then (
					f = fopen fname "wb"
				)
			)--end if/else AppendFile
		
			if fname != undefined then (

				DFFout f $selection MMC.checked TUV.checked CPV.checked NOR.checked expscale ver SAColBase
    	        fclose f
            
				if AppendFile.checked == true then (
					deleteFile Sname
					renameFile fname Sname
					format "\nModels appended to file:% !\n" Sname
				)else	format "\nfile:% exported!\n" fname
			
			)--end if f!=undefined	
		
			RootObj.transform = bkupRootTran		
		
		)--end if RootObj
		
		)
		
		) else (MessageBox "Select the Objects you want to export.\n And then press 'Export DFF' button" title:"Selection Error") --end

	)--end on exp

)--end rollout DFFexPara


rollout aboutRoll "About" (
	label l1 "GTA DFF IO SA Beta"
	label l2 " "
	label s1 "   - 2nd UV Map Skipped" align:#left
	label s2 "   - Collision Quick Hack" align:#left
	label s3 "   - Global GeoFlag only" align:#left
	
	label l3 " " 
	label l4 "by Kam" align:#left across:2
	label l5 "30Jun05" align:#right
	label l6 "kam.lai@ntlworld.com"
)

rollout dmyHelper "Dummies/Bones Helper" (
	spinner dmyboxsize "Size: " range:[0.00000001,100000,dummysize]
	button dmyasBox "Box" width:40 tooltip:"Show Dummies/bones as box" align:#left across:3
	button dmynLink "Link" width:40 tooltip:"Show Dummies/bones as box with Links" align:#center	
	button dmyasBone "Bone" width:40 tooltip:"Show Dummies/bones as bone" align:#right

	on dmyboxsize changed val do (
		for dmy in $selection where classof dmy == Dummy do (
			dmy.boxsize = [val,val,val]
		)	
	)

	on dmyasBox pressed do (
		for dmy in $selection where classof dmy == Dummy do (
			dmy.showLinksOnly = false
			dmy.showLinks = false
		)
		forceCompleteRedraw()
	)
	on dmynLink pressed do (
		for dmy in $selection where classof dmy == Dummy do (
			dmy.showLinksOnly = false
			dmy.showLinks = true
		)
		forceCompleteRedraw()
	)
	
	on dmyasBone pressed do (
		for dmy in $selection where classof dmy == Dummy do dmy.showLinksOnly = true
		forceCompleteRedraw()
	)
)--end rollout dmyHelper

if Kam_GTA != undefined then closeRolloutFloater Kam_GTA
Kam_GTA = newRolloutFloater "GTA IO SA beta" 175 365 10 100		
addRollout DFFinPara Kam_GTA
addRollout DFFexPara Kam_GTA rolledup:true
addRollout dmyHelper Kam_GTA rolledup:true
addRollout aboutRoll Kam_GTA rolledup:true
