program audext;

{$APPTYPE CONSOLE}

(*

GTA3 audio extractor by Nullpointer ( tgirmann@web.de )

This program is free software under the terms set forth in the GPL
( see http://www.gnu.org/copyleft/gpl.html for license agreement)

It can be compiled using Delphi 6 and maybe FreePascal.

This program's job is extracting all the pieces of audio contained within a
GTA3 RAW+SDT file to single easy-to-edit WAV files.

*)


uses
  SysUtils;

var
  raw,sdt,wav :file;
  inf :text;
  sdtstruc:record
    startpos : integer;
    length : integer;
    samplerate : integer;
    unknown1 : integer;
    unknown2 : integer;
  end;
  wavheader:record
    RIFF : array[0..3] of char;
    filesizeminus8 : integer;
    WAVEfmt : array[0..7] of char;
    const16 : integer;
    const1 : word;
    channels : word;
    samplerate : integer;
    byterate : integer;
    bytespersamples : word;
    bitspersample : word;
    data : array[0..3] of char;
    filesizeminus44 : integer;
  end;
  buf:pointer;
  n :integer;
  s :string;
  path :string;

begin
  // insert the path to the GTA3 audio folder if you are not going to run this
  // program from within that folder
  path := '';

  // The SDT file contains information about the audio pieces
  AssignFile(sdt,path+'sfx.SDT');
  Reset(sdt,1);

  // The RAW file contains the audio itself - plain audio without further info
  AssignFile(raw,path+'sfx.RAW');
  Reset(raw,1);

  // This file will be required by the importer - it holds all information
  // that does not fit into the WAV files
  AssignFile(inf,path+'sfx.INF');
  Rewrite(inf);

  // write a few lines of information
  Writeln(inf,'; Each line consists of three parts: WAVfilename, unknown1, unknown2');
  Writeln(inf,';');
  Writeln(inf,'; These parts are separated by tabulator signs. Inserting/removing text may corrupt this file.');
  Writeln(inf,';');
  Writeln(inf,'; I recommend editing this file with notepad.');
  Writeln(inf,';');
  Writeln(inf,'; If a wav file does not loop correctly try using 0 for unknown1 and -1 for unknown2.');
  Writeln(inf,';');
  
  // The main extractor loop
  n := 0;
  while not eof(sdt) do begin

    // load info for a piece of audio
    BlockRead(sdt,sdtstruc,20);

    // construct the WAV file header
    with wavheader do begin
      RIFF := 'RIFF';
      filesizeminus8 := sdtstruc.length+36;
      WAVEfmt := 'WAVEfmt ';
      const16 := 16;
      const1 := 1;
      channels := 1;
      samplerate := sdtstruc.samplerate;
      bitspersample := 16;
      bytespersamples := 2;
      byterate := samplerate*bytespersamples;
      data := 'data';
      filesizeminus44 := sdtstruc.length;
    end;

    // constructs a numbered wav file name
    s := 'sfx'
      +char(n div 10000 mod 10+48)
      +char(n div 1000 mod 10+48)
      +char(n div 100 mod 10+48)
      +char(n div 10 mod 10+48)
      +char(n div 1 mod 10+48)
      +'.wav';

    // create wav file
    AssignFile(wav,path+s);
    Rewrite(wav,1);
    BlockWrite(wav,wavheader,44);

    // read the sound itself from the RAW file and put it into the WAV file
    GetMem(buf,sdtstruc.length);
    Seek(raw,sdtstruc.startpos);
    BlockRead(raw,buf^,sdtstruc.length);
    BlockWrite(wav,buf^,sdtstruc.length);
    FreeMem(buf,sdtstruc.length);

    // close the WAV file
    CloseFile(wav);

    // create a line of info for the INF file
    Writeln(inf,s,#9,sdtstruc.unknown1,#9,sdtstruc.unknown2);

    // increment the file counter
    inc(n)
  end;

  // close all involved files
  CloseFile(inf);
  CloseFile(raw);
  CloseFile(sdt);
end.
