program audimp;

{$APPTYPE CONSOLE}

(*

GTA3 audio importer by Nullpointer ( tgirmann@web.de )

This program is free software under the terms set forth in the GPL
( see http://www.gnu.org/copyleft/gpl.html for license agreement)

It can be compiled using Delphi 6 and maybe FreePascal.

This program constructs a new GTA3 RAW+SDT file pair from the files which were
previously extracted by the extractor tool.

This file has few comments, see audext.dpr for further ones :)

*)


uses
  SysUtils;

var
  raw,sdt,wav :file;
  inf :text;
  sdtstruc:record
    startpos : integer;
    length : integer;
    samplerate : integer;
    unknown1 : integer;
    unknown2 : integer;
  end;
  wavheader:record
    RIFF : array[0..3] of char;
    filesizeminus8 : integer;
    WAVEfmt : array[0..7] of char;
    const16 : integer;
    const1 : word;
    channels : word;
    samplerate : integer;
    byterate : integer;
    bytespersamples : word;
    bitspersample : word;
    data : array[0..3] of char;
    filesizeminus44 : integer;
  end;
  buf:pointer;
  i,code :integer;
  s :string;
  s2 :string;
  path :string;

begin
  path := '';
  AssignFile(inf,path+'sfx.INF');
  Reset(inf);
  AssignFile(sdt,path+'sfx.SDT');
  Rewrite(sdt,1);
  AssignFile(raw,path+'sfx.RAW');
  Rewrite(raw,1);
  while not eof(inf) do begin
    // the following code reads a line of text from the INF file and
    // splits it at the tabulator positions into 3 pieces:
    // filename, unknown value 1, unknown value 2
    Readln(inf,s);
    s := trim(s);
    if (s='') or (s[1]=';') then continue;
    i := pos(#9,s);
    if i=0 then continue;
    s2 := trim(copy(s,1,i-1));
    s := copy(s,i+1,length(s)-i);
    AssignFile(wav,path+s2);

    i := pos(#9,s);
    if i=0 then continue;
    s2 := trim(copy(s,1,i-1));
    s := copy(s,i+1,length(s)-i);
    Val(s2,sdtstruc.unknown1,code);
    if code<>0 then continue;

    i := pos(#9,s);
    if i=0 then
      s2 := trim(s)
    else
      s2 := trim(copy(s,1,i-1));
    Val(s2,sdtstruc.unknown2,code);
    if code<>0 then continue;

    // read WAV file header and copy sample rate and length into the sdt info structure
    Reset(wav,1);
    BlockRead(wav,wavheader,44);
    sdtstruc.startpos := FilePos(raw);
    sdtstruc.length := wavheader.filesizeminus44;
    sdtstruc.samplerate := wavheader.samplerate;

    // copy the block of audio data
    GetMem(buf,sdtstruc.length);
    BlockRead(wav,buf^,sdtstruc.length);
    BlockWrite(raw,buf^,sdtstruc.length);
    FreeMem(buf,sdtstruc.length);

    CloseFile(wav);
    BlockWrite(sdt,sdtstruc,20);
  end;
  CloseFile(inf);
  CloseFile(raw);
  CloseFile(sdt);
end.

