Attribute VB_Name = "modCommon"
'Module Plan:
'
'Common Routines
'    Navigation - via menus or listbox.
'    Clearing Flags - nulls every value and unticks every tickbox.
'    Gathering Flags - add weighted checkbox array and set to flagset.
'    Assigning Flags - disect weightings from flagset and set to checkbox array.

Option Explicit
Global Weighted(0 To 26) As String    'Contains decimal weightings

'NAVIGATION
Sub Navigation(Selected As Integer)
Dim i As Integer

'Show and hide appropriate panes:
If Selected = -1 Then 'If nothing in the list has been selected:
     frmMain.fraPane(0).Visible = True 'show the first pane
Else 'Something has been selected:
    For i = 0 To 7 'For all eight frames:
        If i = Selected Then
            frmMain.fraPane(i).Visible = True 'show the matching pane
            frmMain.mnuPane(i).Checked = True  'tick the appropriate menu.
        Else
            frmMain.fraPane(i).Visible = False 'hide unmatching panes
            frmMain.mnuPane(i).Checked = False  'tick the appropriate menu.
        End If
    Next i
End If

End Sub

'CLEARING FLAGS
Sub ClearAll()
Dim i As Integer

For i = 0 To 27     'There are 28 checkboxes to clear in the array,
     frmMain.chkflag(i).Value = vbUnchecked  'untick this checkbox.
Next i

End Sub

'GATHERING ALL FLAGS
Sub GatherAll()
Dim i As Integer
frmMain.txtOutput = "0"

'Every time a checkbox is ticked/unticked, this process is run:
For i = 0 To 27     'There are 28 checkboxes to run through in the array.
     'If the checkbox is ticked, then add it's "weighted" value to the output textbox.
     If frmMain.chkflag(i) = vbChecked Then frmMain.txtOutput = frmMain.txtOutput + (2 ^ i)
Next i

'As we had to add up in decimal, this converts the output to hexidecimal:
frmMain.txtOutput = Hex(frmMain.txtOutput)
End Sub
