VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "FlagStudio"
   ClientHeight    =   8790
   ClientLeft      =   45
   ClientTop       =   720
   ClientWidth     =   15135
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   8790
   ScaleWidth      =   15135
   Begin VB.Frame fraPane 
      Caption         =   "Summary"
      Height          =   4215
      Index           =   0
      Left            =   1200
      TabIndex        =   1
      Top             =   120
      Width           =   3375
      Begin VB.CommandButton cmdClearAll 
         Cancel          =   -1  'True
         Caption         =   "&Clear All Flags"
         Height          =   495
         Left            =   840
         TabIndex        =   67
         Top             =   3360
         Width           =   1695
      End
      Begin VB.TextBox txtOutput 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "Century Gothic"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   345
         Left            =   1440
         Locked          =   -1  'True
         TabIndex        =   4
         Text            =   "0"
         Top             =   1920
         Width           =   1575
      End
      Begin VB.Label lblInstructions 
         Caption         =   "Copy to column ""ae"" in the GTA handling file ""\data\handling.cfg"" "
         Height          =   495
         Left            =   120
         TabIndex        =   66
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Line linSummarySplitter 
         BorderColor     =   &H80000014&
         Index           =   1
         X1              =   120
         X2              =   3240
         Y1              =   1560
         Y2              =   1560
      End
      Begin VB.Label lblIntroduction 
         Caption         =   $"frmMain.frx":0442
         Height          =   855
         Left            =   120
         TabIndex        =   2
         Top             =   360
         Width           =   3135
      End
      Begin VB.Label lblOutput 
         Alignment       =   1  'Right Justify
         Caption         =   "Flag &Data:"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   1920
         Width           =   1215
      End
      Begin VB.Line linSummarySplitter 
         BorderColor     =   &H80000010&
         BorderWidth     =   2
         Index           =   0
         X1              =   120
         X2              =   3240
         Y1              =   1560
         Y2              =   1560
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "7th Digit"
      Height          =   4215
      Index           =   7
      Left            =   11640
      TabIndex        =   59
      Top             =   4440
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "SPECIAL_FLIGHT"
         Height          =   255
         Index           =   27
         Left            =   120
         TabIndex        =   68
         Top             =   3120
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "GOOD_IN_SAND"
         Height          =   255
         Index           =   26
         Left            =   240
         TabIndex        =   65
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "NARROW_FRONT"
         Height          =   255
         Index           =   25
         Left            =   240
         TabIndex        =   63
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "FAT_REAR"
         Height          =   255
         Index           =   24
         Left            =   240
         TabIndex        =   61
         Top             =   240
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Used by flying vehicles but of exact purpose is not certain."
         Height          =   735
         Index           =   27
         Left            =   120
         TabIndex        =   69
         Top             =   3360
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Stops the vehicle from getting stuck in the sandy surface."
         Height          =   735
         Index           =   26
         Left            =   120
         TabIndex        =   64
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Thins the front wheels and tyres."
         Height          =   735
         Index           =   25
         Left            =   120
         TabIndex        =   62
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Widens the rear wheels and tyres."
         Height          =   735
         Index           =   24
         Left            =   120
         TabIndex        =   60
         Top             =   480
         Width           =   3135
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "6th Digit"
      Height          =   4215
      Index           =   6
      Left            =   8160
      TabIndex        =   50
      Top             =   4440
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "SIT_IN_BOAT"
         Height          =   255
         Index           =   23
         Left            =   240
         TabIndex        =   58
         Top             =   3120
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "HANDBRAKE_TYRE"
         Height          =   255
         Index           =   22
         Left            =   240
         TabIndex        =   56
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "REARWHEEL_1ST"
         Height          =   255
         Index           =   21
         Left            =   240
         TabIndex        =   54
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "NO_EXHAUST"
         Height          =   255
         Index           =   20
         Left            =   240
         TabIndex        =   52
         Top             =   240
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Makes the player sit instead of stand when inside this boat vehicle."
         Height          =   735
         Index           =   23
         Left            =   120
         TabIndex        =   57
         Top             =   3360
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Doesn't seem to have any effect."
         Height          =   735
         Index           =   22
         Left            =   120
         TabIndex        =   55
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Doesn't seem to have any effect."
         Height          =   735
         Index           =   21
         Left            =   120
         TabIndex        =   53
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Removes all exhaust plumes."
         Height          =   735
         Index           =   20
         Left            =   120
         TabIndex        =   51
         Top             =   480
         Width           =   3135
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "5th Digit"
      Height          =   4215
      Index           =   5
      Left            =   4680
      TabIndex        =   41
      Top             =   4440
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_BOAT"
         Height          =   255
         Index           =   19
         Left            =   240
         TabIndex        =   49
         Top             =   3120
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_PLANE"
         Height          =   255
         Index           =   18
         Left            =   240
         TabIndex        =   47
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_HELI"
         Height          =   255
         Index           =   17
         Left            =   240
         TabIndex        =   45
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_BIKE"
         Height          =   255
         Index           =   16
         Left            =   240
         TabIndex        =   43
         Top             =   240
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Indicates that this vehicle also has a special handling entry in the ""boat"" section."
         Height          =   735
         Index           =   19
         Left            =   120
         TabIndex        =   48
         Top             =   3360
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Indicates that this vehicle also has a special handling entry in the ""plane"" section."
         Height          =   735
         Index           =   18
         Left            =   120
         TabIndex        =   46
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Indicates that this vehicle also has a special handling entry in the ""helicopter"" section."
         Height          =   735
         Index           =   17
         Left            =   120
         TabIndex        =   44
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Indicates that this vehicle also has a special handling entry in the ""bike"" section."
         Height          =   735
         Index           =   16
         Left            =   120
         TabIndex        =   42
         Top             =   480
         Width           =   3135
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "4th Digit"
      Height          =   4215
      Index           =   4
      Left            =   1200
      TabIndex        =   32
      Top             =   4440
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "HALOGEN_LIGHTS"
         Height          =   255
         Index           =   15
         Left            =   240
         TabIndex        =   40
         Top             =   3120
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_BIG"
         Height          =   255
         Index           =   14
         Left            =   240
         TabIndex        =   38
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "HAS_NO_ROOF"
         Height          =   255
         Index           =   13
         Left            =   240
         TabIndex        =   36
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "NEUTRAL_HANDLING"
         Height          =   255
         Index           =   12
         Left            =   240
         TabIndex        =   34
         Top             =   240
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Makes the lights brighter and gives them a slight tint."
         Height          =   735
         Index           =   15
         Left            =   120
         TabIndex        =   39
         Top             =   3360
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Enables a beeping sound to come on when the vehicle reverses."
         Height          =   735
         Index           =   14
         Left            =   120
         TabIndex        =   37
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Has several detailed effects, including the ability to shoot the occupants more easily."
         Height          =   735
         Index           =   13
         Left            =   120
         TabIndex        =   35
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Alters the performance of the car when under AI control to make it less easy to spin."
         Height          =   735
         Index           =   12
         Left            =   120
         TabIndex        =   33
         Top             =   480
         Width           =   3135
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "3rd Digit"
      Height          =   4215
      Index           =   3
      Left            =   11640
      TabIndex        =   23
      Top             =   120
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "NONPLAYER_STABILISER"
         Height          =   255
         Index           =   11
         Left            =   240
         TabIndex        =   31
         Top             =   3120
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "NOSWING_BOOT"
         Height          =   255
         Index           =   10
         Left            =   240
         TabIndex        =   29
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "TAILGATE_BOOT"
         Height          =   255
         Index           =   9
         Left            =   240
         TabIndex        =   27
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "DBL_EXHAUST"
         Height          =   255
         Index           =   8
         Left            =   240
         TabIndex        =   25
         Top             =   240
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Alters the performance of the car when under AI control to make it less likely to flip."
         Height          =   735
         Index           =   11
         Left            =   120
         TabIndex        =   30
         Top             =   3360
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Stops the boot from hinging at all."
         Height          =   735
         Index           =   10
         Left            =   120
         TabIndex        =   28
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Makes the boot hinge from the bottom edge."
         Height          =   735
         Index           =   9
         Left            =   120
         TabIndex        =   26
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Creates a second exhaust plume."
         Height          =   735
         Index           =   8
         Left            =   120
         TabIndex        =   24
         Top             =   480
         Width           =   3135
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "2nd Digit"
      Height          =   4215
      Index           =   2
      Left            =   8160
      TabIndex        =   14
      Top             =   120
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "NO_DOORS"
         Height          =   255
         Index           =   4
         Left            =   240
         TabIndex        =   16
         Top             =   240
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_VAN"
         Height          =   255
         Index           =   5
         Left            =   240
         TabIndex        =   18
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_BUS"
         Height          =   255
         Index           =   6
         Left            =   240
         TabIndex        =   20
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "IS_LOW"
         Height          =   255
         Index           =   7
         Left            =   240
         TabIndex        =   22
         Top             =   3120
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Removes the need for door dummies on the car.  The player will slide directly inside."
         Height          =   735
         Index           =   7
         Left            =   120
         TabIndex        =   15
         Top             =   480
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Allows two doors at the back of the vehicle and makes any passengers sit sideways."
         Height          =   735
         Index           =   6
         Left            =   120
         TabIndex        =   17
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Sets this vehicle to pick up and set down passengers when it reaches bus stops."
         Height          =   735
         Index           =   5
         Left            =   120
         TabIndex        =   19
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Makes the player recline in the seat, making him lower in the car."
         Height          =   735
         Index           =   4
         Left            =   120
         TabIndex        =   21
         Top             =   3360
         Width           =   3135
      End
   End
   Begin VB.Frame fraPane 
      Caption         =   "1st Digit"
      Height          =   4215
      Index           =   1
      Left            =   4680
      TabIndex        =   5
      Top             =   120
      Visible         =   0   'False
      Width           =   3375
      Begin VB.CheckBox chkflag 
         Caption         =   "HANGING_BOOT"
         Height          =   255
         Index           =   3
         Left            =   240
         TabIndex        =   13
         Top             =   3120
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "REV_BONNET"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   11
         Top             =   2160
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "2G_BOOST"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   9
         Top             =   1200
         Width           =   3015
      End
      Begin VB.CheckBox chkflag 
         Caption         =   "1G_BOOST"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   7
         Top             =   240
         Width           =   3015
      End
      Begin VB.Label lblDescription 
         Caption         =   "Makes the boot hinge from the top edge."
         Height          =   735
         Index           =   3
         Left            =   120
         TabIndex        =   12
         Top             =   3360
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Makes the bonnet and boot of the car hinge in the opposite direction."
         Height          =   735
         Index           =   2
         Left            =   120
         TabIndex        =   10
         Top             =   2400
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Gives extra power when cornering and climbing hills at medium speeds."
         Height          =   735
         Index           =   1
         Left            =   120
         TabIndex        =   8
         Top             =   1440
         Width           =   3135
      End
      Begin VB.Label lblDescription 
         Caption         =   "Gives extra power to the car at very low speeds, allowing the car to wheelspin from standing start."
         Height          =   735
         Index           =   0
         Left            =   120
         TabIndex        =   6
         Top             =   480
         Width           =   3135
      End
   End
   Begin VB.ListBox lstPane 
      Height          =   4155
      ItemData        =   "frmMain.frx":04ED
      Left            =   120
      List            =   "frmMain.frx":0509
      TabIndex        =   0
      Top             =   240
      Width           =   915
   End
   Begin VB.Line linMenuSplitter 
      BorderColor     =   &H80000010&
      Index           =   0
      X1              =   0
      X2              =   15240
      Y1              =   0
      Y2              =   0
   End
   Begin VB.Line linMenuSplitter 
      BorderColor     =   &H80000014&
      BorderWidth     =   3
      Index           =   1
      X1              =   0
      X2              =   15240
      Y1              =   0
      Y2              =   0
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileClear 
         Caption         =   "&Clear all flags"
      End
      Begin VB.Menu mnuFileSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
         Shortcut        =   ^Q
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "&View"
      Begin VB.Menu mnuPane 
         Caption         =   "&Summary"
         Checked         =   -1  'True
         Index           =   0
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&1st Digit"
         Index           =   1
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&2nd Digit"
         Index           =   2
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&3rd Digit"
         Index           =   3
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&4th Digit"
         Index           =   4
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&5th Digit"
         Index           =   5
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&6th Digit"
         Index           =   6
      End
      Begin VB.Menu mnuPane 
         Caption         =   "&7th Digit"
         Index           =   7
      End
      Begin VB.Menu mnuViewSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewSingle 
         Caption         =   "&One row, One Column (Single)"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuViewWide 
         Caption         =   "&Two Rows, Four Columns (Wide)"
         Checked         =   -1  'True
         Shortcut        =   ^W
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "&About"
         Shortcut        =   {F1}
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Purpose of this project:
'One parameter for the handling data of the cars in "Grand Theft Auto Vice City" are special features
'which are enabled/disabled using a 27-bit digit, each bit representing one special feature.  This "flagset"
'is stored as hexidecimal in the handling file and therefore I devised this utility so that people can easily
'set up the special features they want a car to use.
'    111111111111111111111111111 = AFFFFFF
'With all 27 features enabled, there are seven hexicimal "digits".  I seperate the interface into navigable
'panes handling one digit each.  There is also the "Summary" pane for use with input and output.

'Code Plan:
'MODULE:  Common Procedures - Gathering & Assigning flag values.
'FORM:  User Events - Navigation, Menus, Control Events.

Option Explicit

'SETTING INITIAL CONDITIONS.
Private Sub Form_Load()
Dim i As Integer

'Stack all the panes on top of the first:
For i = 0 To 7
     fraPane(i).Top = fraPane(0).Top
     fraPane(i).Left = fraPane(0).Left
Next i

'Shrink form to single pane view.
mnuViewSingle_Click

End Sub

Private Sub Form_Terminate()
End
End Sub

'NAVIGATION via listbox.
Private Sub lstPane_Click()
Navigation (lstPane.ListIndex)  'Runs the subroutine of this name in the "modCommon" module.
End Sub

Private Sub mnuAbout_Click()
frmAbout.Show (vbModal)
End Sub

'FILE MENU - Clear All
Private Sub mnuFileClear_Click()
ClearAll
End Sub

'FILE MENU - Exit
Private Sub mnuFileExit_Click()
Dim Answer As Integer

'The button the user clicks is captured and placed as an integer in the "answer" variable:
Answer = MsgBox("Vous tes sur de vouloir quitter?", vbQuestion + vbYesNo, "Confirmation pour Quitter?")
If Answer = vbYes Then End    'Uses the Visual Basic constant that a "Yes" click event returns.

End Sub

'NAVIGATION via "Pane" menu.
Private Sub mnuPane_Click(Index As Integer)
Navigation (Index)  'Runs the subroutine of this name in the "modCommon" module.
End Sub

'CHECKBOX EVENT
Private Sub chkFlag_Click(Index As Integer)
GatherAll     'Runs the subroutine of this name in the "modCommon" module.
End Sub

'COMMAND EVENT
Private Sub cmdClearAll_Click()
ClearAll  'Runs the subroutine of this name in the "modCommon" module.
End Sub

Private Sub mnuViewSingle_Click()
Dim i As Integer

'Place tick by appropriate menu item:
mnuViewSingle.Checked = True
mnuViewWide.Checked = False

'Hide all panes:
For i = 0 To 7
     fraPane(i).Visible = False
Next i

'Rearrange panes to be on top of each other:
For i = 0 To 7
     fraPane(i).Top = 120
     fraPane(i).Left = 1200
Next i

'Show navigation:
lstPane.Visible = True

'Shrink form to show single frame.
Me.Height = 5250
Me.Width = 4800

'Show selected pane:
Navigation (lstPane.ListIndex)  'runs the subroutine of this name in the "modCommon" module.

End Sub


Private Sub mnuViewWide_Click()
Dim i As Integer

'Place tick by appropriate menu item:
mnuViewSingle.Checked = False
mnuViewWide.Checked = True

'SGrow form to show all frames.
Me.Height = 9550
Me.Width = 14200

'Hide navigation:
lstPane.Visible = False

'Rearrange panes:
For i = 0 To 7
     If i < 4 Then 'for the first row of panes:
          fraPane(i).Top = 120 'move level with first pane
          fraPane(i).Left = 120 + i * (fraPane(0).Width + 120) 'move right of previous pane
     Else 'for the second row of panes:
          fraPane(i).Top = 120 + fraPane(0).Height + 120 'move below first pane
          fraPane(i).Left = 120 + (i - 4) * (fraPane(0).Width + 120) 'move right of previous pane
     End If
Next i

'Show all panes:
For i = 0 To 7
     fraPane(i).Visible = True
Next i

End Sub

